﻿#nullable enable
namespace Hims.Api.Models.Patient
{
    /// <summary>
    /// The patient upload scan document Request.
    /// </summary>
    public class UploadPatientScanDocument
    {
        /// <summary>
        /// Gets or sets the uploaded by.
        /// </summary>
        public int UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the book scan appointment id.
        /// </summary>
        public int BookScanAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the scan document id.
        /// </summary>
        public int ScanDocumentId { get; set; }              

        /// <summary>
        /// Gets or sets the document url.
        /// </summary>
        public string? DocumentUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the document name.
        /// </summary>
        public string? DocumentName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the content type.
        /// </summary>
        public string? ContentType { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the size.
        /// </summary>
        public float Size { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the uploaded by name.
        /// </summary>
        public string? UploadedByName { get; set; }

        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public string? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }
    }
}
